using System;

namespace SPStudio
{
	/// <summary>
	/// Holds two Vector3Ds to represent a line
	/// in 3D space.
	/// Knows how to test
	/// if it intersects a 
	/// given Triangle3D.
	/// </summary>
	public class Line3D
	{
		#region Public Vars
		public Vector3D p1 = new Vector3D();
		public Vector3D p2 = new Vector3D();
		#endregion

		#region Constructors
		/// <summary>
		/// Default constructor that
		/// uses the Vector3D default constructor
		/// to assign both points.
		/// </summary>
		public Line3D()
		{
		}

		/// <summary>
		/// Takes in two Vector3Ds and
		/// assigns their individual
		/// x,y, and z components to
		/// the Vector3Ds making up
		/// this line. It does not
		/// create references to the
		/// Vector3Ds.
		/// </summary>
		/// <param name="P1"></param>
		/// <param name="P2"></param>
		public Line3D(Vector3D P1, Vector3D P2)
		{
			p1.x = P1.x;
			p1.y = P1.y;
			p1.z = P1.z;

			p2.x = P2.x;
			p2.y = P2.y;
			p2.z = P2.z;
		}
		#endregion

		#region Calculate Intersection
		/// <summary>
		/// Calculate the intersection of
		/// of the Line3D with a Triangle3D. 
		/// </summary>
		/// <param name="T"></param>
		/// <returns></returns>
		public bool intersectsTriangle(Triangle3D T)
		{
			VectorMath vm = new VectorMath();
			//compute plane eqn for T
			Vector3D E1 = vm.SUB(T.p2,T.p1);
			Vector3D E2 = vm.SUB(T.p3,T.p1);
			Vector3D N = vm.CROSS(E1,E2);
			double n = vm.DOT(N,vm.SUB(T.p1,p1));
			double d = vm.DOT(N,vm.SUB(p2,p1));

			//if d=0.0 then the entire line
			//is on the triangles plane, thus it is
			//possible that every point 
			//on the line intersects
			//the triangle. If this occurs we
			//simply return false.
			if (d==0.0) return false;
			double u = n/d;

			if((u>=0.0)&&(u<=1.0))
			{
				//We now know that the line intersects
				//the triangle's plane and where.
				//We get the point on the triangle's
				//plane where the line intersected it.
				Vector3D test = vm.ADD(p1,vm.MULT(vm.SUB(p2,p1),u));
				//Verify that the intersection point is within
				//the triangle
				if(check_same_clock_dir(T.p1, T.p2, test, N))
				{
					if(check_same_clock_dir(T.p2, T.p3, test, N))
					{
						if(check_same_clock_dir(T.p3, T.p1, test, N))
						{
							return true;
						}
					}
				}
			}
			return false;
		}

		/// <summary>
		/// The Normal of the original triangle
		/// must be in the same direction as
		/// the Normal of the triangle formed
		/// from P1, P2, and iP. Where P1 and P2
		/// are combinations of the 3 points of the original
		/// triangle and iP is the intersection point.
		/// </summary>
		/// <param name="P1"></param>
		/// <param name="P2"></param>
		/// <param name="iP"></param>
		/// <param name="Norm"></param>
		/// <returns></returns>
		private bool check_same_clock_dir(Vector3D P1, Vector3D P2, Vector3D iP, Vector3D Norm)
		{  
			VectorMath vm = new VectorMath();
			double dotprod;

			//Obtain the normal of the
			//new triangle.
			Vector3D E1 = vm.SUB(P2,P1);
			Vector3D E2 = vm.SUB(iP,P1);
			Vector3D N = vm.CROSS(E1,E2);

			//DOT product the original normal
			//with the new normal
			dotprod = vm.DOT(N,Norm);

			//If the DOT product is negative
			//then they are not the same direction
			if(dotprod < 0.0) return false;
			else return true;
		}
		#endregion
	}
}
